<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require 'connect.php';


// DataTables parameters
$start = $_POST['start'] ?? 0;
$length = $_POST['length'] ?? 100;
$search = $_POST['search']['value'] ?? '';

// Total records (without filtering)
$result = $conn->query("SELECT COUNT(*) AS count FROM users");
$row = $result->fetch_assoc();
$totalRecords = $row['count'];

// Filtered count and data query
$searchQuery = '';
$searchParams = [];
if (!empty($search)) {
    $searchQuery = " WHERE email LIKE ? OR phone LIKE ? OR walletid LIKE ? OR username LIKE ?";
    $searchParam = "%$search%";
    $searchParams = array_fill(0, 4, $searchParam);
}

// Get filtered count
$countSql = "SELECT COUNT(*) AS count FROM users" . $searchQuery;
$countStmt = $conn->prepare($countSql);
if (!empty($search)) {
    $countStmt->bind_param(str_repeat('s', 4), ...$searchParams);
}
$countStmt->execute();
$countResult = $countStmt->get_result();
$countRow = $countResult->fetch_assoc();
$recordsFiltered = $countRow['count'];

// Final data query with LIMIT
$dataSql = "SELECT * FROM users" . $searchQuery . " LIMIT ?, ?";
$dataStmt = $conn->prepare($dataSql);

if (!empty($search)) {
    $types = str_repeat('s', 4) . 'ii';
    $params = array_merge($searchParams, [(int) $start, (int) $length]);
    $dataStmt->bind_param($types, ...$params);
} else {
    $dataStmt->bind_param('ii', $start, $length);
}

$dataStmt->execute();
$result = $dataStmt->get_result();

$data = [];
$cnt = 0;

$btc = 0;
$eth = 0;
$tron = 0;
$sol = 0;
$usdt_trc20 = 0;
$usdt_erc20 = 0;

$totalbal = 0;

$myy = mysqli_query($conn, "select price, coin_name from crypto_prices ");
if (mysqli_num_rows($myy) > 0) {
    while ($rowy = mysqli_fetch_assoc($myy)) {
        if ($rowy["coin_name"] == 'bitcoin') {
            $btc = $rowy['price'];
        }
        if ($rowy["coin_name"] == 'ethereum') {
            $eth = $rowy['price'];
        }
        if ($rowy["coin_name"] == 'tron') {
            $tron = $rowy['price'];
        }
        if ($rowy["coin_name"] == 'solana') {
            $sol = $rowy['price'];
        }
        if ($rowy["coin_name"] == 'tether') {
            $usdt_trc20 = $rowy['price'];
            $usdt_erc20 = $rowy['price'];
        }

    }
}

while ($row = $result->fetch_assoc()) {
    $email = $row['email'];
    $userid = $row['id'];

    $qu = mysqli_query($conn, "select id, coin, balance from assets where userid = '$userid'");
    while ($row2 = mysqli_fetch_assoc($qu)) {
        if ($row2['coin'] == "Bitcoin") {
            $totalbal += ($row2['balance'] * $btc);
        }
        if ($row2['coin'] == "Ethereum") {
            $totalbal += ($row2['balance'] * $eth);
        }
        if ($row2['coin'] == "Solana") {
            $totalbal += ($row2['balance'] * $sol);
        }
        if ($row2['coin'] == "Tron") {
            $totalbal += ($row2['balance'] * $tron);
        }
        if ($row2['coin'] == "Usdt_trc20") {
            $totalbal += ($row2['balance'] * $usdt_trc20);
        }
        if ($row2['coin'] == "Usdt_erc20") {
            $totalbal += ($row2['balance'] * $usdt_erc20);
        }
    }






    $cnt += 1;
    $data[] = [
        "id" => $cnt,
        "name" => $row['username'],
        "email" => $email,
        "amount" => "$" . number_format($totalbal),
        "code" => strtoupper($row['walletid']),
        "bonus" => "$" . $row['networkfee'],
        "country" => $row['country'],
        "state" => $row['state'],
        "phone" => $row['phone'],
        "date" => date('d M, Y h:ia', strtotime($row['datetime'])),
    ];
    $totalbal = 0;
}

// Return JSON for DataTables
echo json_encode([
    "draw" => intval($_POST['draw']),
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => $recordsFiltered,
    "data" => $data
]);
?>