<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
ob_start();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'connect.php';

$asset = $_POST['asset'];
$amount = $_POST['amount'];
$userid = $_POST['userid'];
$type = $_POST['type'];

$btc = 0;
$eth = 0;
$tron = 0;
$sol = 0;
$usdt_trc20 = 0;
$usdt_erc20 = 0;

if ($amount <= 0) {
    echo json_encode(['status' => "failed", "data" => "Invalid quantity. Please input number above zero"]);
    return;
}



$myy = mysqli_query($conn, "select price, coin_name from crypto_prices ");
if (mysqli_num_rows($myy) > 0) {
    while ($rowy = mysqli_fetch_assoc($myy)) {
        if ($rowy["coin_name"] == 'bitcoin') {
            $btc = $rowy['price'];
        }
        if ($rowy["coin_name"] == 'ethereum') {
            $eth = $rowy['price'];
        }
        if ($rowy["coin_name"] == 'tron') {
            $tron = $rowy['price'];
        }
        if ($rowy["coin_name"] == 'solana') {
            $sol = $rowy['price'];
        }
        if ($rowy["coin_name"] == 'tether') {
            $usdt_trc20 = $rowy['price'];
            $usdt_erc20 = $rowy['price'];
        }
    }
}



// Retrieve current asset balance for the user
$stmt = mysqli_query($conn, "SELECT balance FROM assets WHERE coin = '$asset' AND userid = '$userid'");
if ($rw = mysqli_fetch_assoc($stmt)) {
    $bal = $rw['balance'];
}


$totalbal = 0;
$code = "";

// Determine the transaction value based on asset type
if ($asset == "BITCOIN" || $asset == "Bitcoin") {
    $totalbal = ($amount * $btc);
    $code = "BTC";
}
if ($asset == "ETHEREUM" || $asset == "Ethereum") {
    $totalbal = ($amount * $eth);
    $code = "ETH";
}
if ($asset == "Solana" || $asset == "Solana") {
    $totalbal = ($amount * $sol);
    $code = "SOL";
}
if ($asset == "TRON" || $asset == "Tron") {
    $totalbal = ($amount * $tron);
    $code = "TRON";
}
if ($asset == "USDT_TRC20" || $asset == "Usdt_trc20") {
    $totalbal = $amount;
    $code = "USDT (TRC20)";
}
if ($asset == "USDT_ERC20" || $asset == "Usdt_erc20") {
    $totalbal = $amount;
    $code = "USDT (ERC20)";
}
$rem = 0;
$transtype = "Received";

$des = "";
if ($type == "CREDIT") {
    $rem = $bal + $amount;
    $des = $asset . " Credited Successfully";
} else {
    $des = $asset . " Debited Successfully";
    $rem = $bal - $amount;
    $transtype = "Sent";
    if ($rem < 0) {
        echo json_encode(['status' => "failed", "data" => "Insufficient " . $asset]);
        return;
    }
}

function getWalletAddress($conn, $as)
{

    if ($as == "Usdt_trc20") {
        $as = "USDT (TRC20)";
    }
    if ($as == "Usdt_erc20") {
        $as = "USDT (ERC20)";
    }

    $ge = mysqli_query($conn, "select walletaddress from wallet_address where asset ='$as'");
    if (mysqli_num_rows($ge) > 0) {
        $wnu = mysqli_fetch_assoc($ge);
        return $wnu['walletaddress'];
    }
}

$adminreceiveraddress = getWalletAddress($conn, $asset);


// Begin the transaction
mysqli_begin_transaction($conn);

try {
    // Update the assets table with the new balance
    $updateSql = "UPDATE assets SET balance = '$rem' WHERE coin = '$asset' AND userid = '$userid'";
    if (!mysqli_query($conn, $updateSql)) {
        throw new Exception("Error updating assets: " . mysqli_error($conn));
    }
    $em = email_username;
    // Insert the new transaction record
    $date = date("Y-m-d H:i:s");
    $insertSql = "INSERT INTO transaction (id, asset, quantity, value, sender_id, receiver_id, status, type, datetime,receiver_walletaddress, transtype)
                  VALUES (0, '$asset', '$amount', '$totalbal', '$em', '$userid', 'SUCCESS', '$type','$date', '$adminreceiveraddress', '')";
    if (!mysqli_query($conn, $insertSql)) {
        throw new Exception("Error inserting transaction: " . mysqli_error($conn));
    }

    // If both queries succeed, commit the transaction
    mysqli_commit($conn);

    $ji = mysqli_query($conn, "select email, username from users where id = '$userid'");
    if (mysqli_num_rows($ji) > 0) {
        if ($row = mysqli_fetch_assoc($ji)) {
            $em = $row['email'];
            $us = $row['username'];

            // sendmail($em, $us, $totalbal, $asset, $type);
            sendmail($em, $us, $totalbal, $asset, $type, $code, $adminreceiveraddress, $amount);
        }
    }




    ob_end_clean();

    echo json_encode(['status' => 'success', 'data' => $des]);
} catch (Exception $e) {
    // An error occurred: rollback the transaction
    mysqli_rollback($conn);
    echo json_encode(['status' => "failed", "data" => "Transaction failed: " . $e->getMessage()]);
}

// function sendmail($email, $firstname, $totalbal, $asset, $type)

function sendmail($email, $firstname, $totalbal, $asset, $type, $coinCode, $walletAddress, $amount)
{
    $totalbalFormatted = number_format($totalbal, 2);
    $isCredit = strtoupper($type) === "CREDIT";

    $subject = ($isCredit ? "Credit" : "Debit") . " / " . site_name;

    $transactionText = $isCredit
        ? "You have received a credit to your <strong>" . strtoupper($asset) . "</strong> wallet."
        : "Your <strong>{$asset}</strong> wallet has been debited.";

    $amountColor = $isCredit ? "#27ae60" : "#e74c3c";
    $sign = $isCredit ? "$" : "$-";
    $directionLabel = $isCredit ? "Sender" : "Receiver";

    $bodyl = '
    <div style="background:#f4f6f8; padding:20px; font-family:Segoe UI, sans-serif;">
      <div style="max-width:600px; margin:auto; background:#ffffff; border-radius:10px; overflow:hidden; box-shadow:0 0 15px rgba(0,0,0,0.05);">
        <div style="background:#1abc9c; color:#fff; padding:30px 20px; text-align:center;">
          <h1 style="margin:0; font-size:24px; font-weight:normal;">' . ($isCredit ? "You've Been Credited" : "Debit Notification") . '</h1>
        </div>
        <div style="padding:30px 20px;">
          <p style="margin:0 0 10px;">Hello <strong>' . htmlspecialchars($firstname) . '</strong>,</p>
          <p style="margin:10px 0 20px;">' . $transactionText . '</p>

          <table cellpadding="6" cellspacing="0" width="100%" style="font-size:15px; line-height:1.6; color:#2c3e50;">
           
            <tr>
              <td><strong>Amount:</strong></td>
              <td style="font-weight:bold;">' . $amount . ' ' . strtoupper($coinCode) . '</td>
            </tr>
            
            
            
<tr>
              <td><strong>Value:</strong></td>
              <td style="color:' . $amountColor . '; font-weight:bold;">' . $sign . $totalbalFormatted . '</td>
            </tr>
     
            <tr>
              <td><strong>Date:</strong></td>
              <td>' . date("F j, Y g:ia") . '</td>
            </tr>
          </table>

          <p style="font-size:14px; color:#7f8c8d; margin-top:20px;">
           For any discrepancies or concerns regarding this transaction, please get in touch with our support team promptly.
          </p>
          <p style="font-size:14px; color:#7f8c8d;">Thank you for choosing <strong>' . site_name . '</strong>.</p>
        </div>
        <div style="background:#ecf0f1; text-align:center; padding:20px; font-size:12px; color:#7f8c8d;">
          <img src="' . logolink . '" alt="Subhavelpro logo" style="width:120px; margin-bottom:10px;"><br>
          &copy; 2025 ' . site_name . '. All rights reserved.<br>
          Email: ' . email_username . ' | Website: ' . site_url . '
        </div>
      </div>
    </div>';

    sendEmailMessage($email, $subject, $bodyl);
}
