<?php
// require('./header/header_access.php');
require 'connect.php';


if (!isset($_POST['email'])) {
    echo json_encode(['status' => 'failed','data' => 'Invalid request email']);
    exit();
}

$email = mysqli_real_escape_string($conn, trim($_POST['email']));
 //$email = 'emperorcuzzy6@gmail.com';
$userid = "";

$res = $conn->query("SELECT id FROM users WHERE email = '$email'");
if ($res && $res->num_rows > 0) {
    $row = $res->fetch_assoc();
    $userid = $row['id'];
}
if ($userid == "") {
    echo json_encode(['status' => 'failed', 'data' => 'User id not found from email']);
    exit();
}

mysqli_begin_transaction($conn);

function getRemoteContent($url)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}


function getCryptoData($coin, $conn)
{
    $coin = $conn->real_escape_string($coin);
    $result = $conn->query("SELECT * FROM crypto_prices WHERE coin_name = '$coin'");

    $now = new DateTime();

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $lastUpdated = new DateTime($row['last_updated']);
        $diffSeconds = $now->getTimestamp() - $lastUpdated->getTimestamp();

        if ($diffSeconds < 3600) {
            return [
                'source' => 'db',
                'coin' => $coin,
                'current_price' => $row['price'],
                'percent_change_1h' => $row['percent_change_1h'],
                'last_updated' => $row['last_updated']
            ];
        }
    }

    // Fetch from CoinGecko
    $url = "https://api.coingecko.com/api/v3/coins/{$coin}?localization=false&tickers=false&market_data=true&community_data=false&developer_data=false&sparkline=false";
    $content = getRemoteContent($url); // You must define this function to use cURL
    $data = json_decode($content, true);

    $price = $data['market_data']['current_price']['usd'] ?? null;
    $percentChange = $data['market_data']['price_change_percentage_1h_in_currency']['usd'] ?? null;

    if ($price === null) {
        return ['error' => 'Failed to fetch valid data from API.'];
    }
    $nowStr = $now->format('Y-m-d H:i:s');

    if ($result && $result->num_rows > 0) {
        // Update record
        
        $stmt = $conn->prepare("UPDATE crypto_prices SET price = ?, percent_change_1h = ?, last_updated = ? WHERE coin_name = ?");
        $stmt->bind_param("ddss", $price, $percentChange, $nowStr, $coin);
    } else {
        // Insert new record
        $stmt = $conn->prepare("INSERT INTO crypto_prices (coin_name, price, percent_change_1h, last_updated) VALUES (?, ?, ?,?)");
        $stmt->bind_param("sdds", $coin, $price, $percentChange, $nowStr);
    }

    $stmt->execute();
    $stmt->close();

    return [
        'source' => 'api',
        'coin' => $coin,
        'current_price' => $price,
        'percent_change_1h' => $percentChange,
        'last_updated' => $nowStr
    ];
}


$bitcoinData = getCryptoData('bitcoin', $conn);
$btc = $bitcoinData['current_price'];
$btcChange = $bitcoinData['percent_change_1h'];

$ethereumData = getCryptoData('ethereum', $conn);
$eth = $ethereumData['current_price'];
$ethChange = $ethereumData['percent_change_1h'];

$tronData = getCryptoData('tron', $conn);
$tron = $tronData['current_price'];
$tronChange = $tronData['percent_change_1h'];

$solData = getCryptoData('solana', $conn);
$sol = $solData['current_price'];
$solChange = $solData['percent_change_1h'];

$usdtData = getCryptoData('tether', $conn);
$usdtTrc = $usdtData['current_price'];
$usdttrcChange = $usdtData['percent_change_1h'];
$usdtErc = $usdtTrc;
$usdtercChange = $usdttrcChange;

mysqli_commit($conn);

$user_btc_bal = 0.0;
$user_eth_bal = 0.0;
$user_sol_bal = 0.0;
$user_tron_bal = 0.0;
$user_usdttrc_bal = 0.0;
$user_usdterc_bal = 0.0;

$user_btc_value = 0.0;
$user_eth_value = 0.0;
$user_sol_value = 0.0;
$user_tron_value = 0.0;
$user_usdttrc_value = 0.0;
$user_usdterc_value = 0.0;




$stmt = mysqli_query($conn, "SELECT coin, balance FROM assets WHERE userid = '$userid'");
if (mysqli_num_rows($stmt) > 0) {
    while ($rows = mysqli_fetch_assoc($stmt)) {

        if ($rows['coin'] == "Bitcoin") {
            $user_btc_bal = $rows['balance'];
            $user_btc_value = $rows['balance'] * $btc;
        }

        if ($rows['coin'] == "Ethereum") {
            $user_eth_bal = $rows['balance'];
            $user_eth_value = $rows['balance'] * $eth;
        }

        if ($rows['coin'] == "Solana") {
            $user_sol_bal = $rows['balance'];
            $user_sol_value = $rows['balance'] * $sol;
        }

        if ($rows['coin'] == "Tron") {
            $user_tron_bal = $rows['balance'];
            $user_tron_value = $rows['balance'] * $tron;

        }

        if ($rows['coin'] == "Usdt_trc20") {
            $user_usdttrc_bal = $rows['balance'];
            $user_usdttrc_value = $rows['balance'] * $usdtTrc;
        }

        if ($rows['coin'] == "Usdt_erc20") {
            $user_usdterc_bal = $rows['balance'];
            $user_usdterc_value = $rows['balance'] * $usdtErc;
        }
    }
} else {
    $datetime = date('Y-m-d H:i:s');
    $coins = ['Bitcoin', 'Ethereum', 'Solana', 'Tron', 'Usdt_trc20', 'Usdt_erc20'];
    $values = [];

    $useridEscaped = $conn->real_escape_string($userid);
    $datetimeEscaped = $conn->real_escape_string($datetime);

    foreach ($coins as $coin) {
        $coinEscaped = $conn->real_escape_string($coin);
        $values[] = "(0, '$coinEscaped', 0, '$useridEscaped', '$datetimeEscaped')";
    }

    $sql = "INSERT INTO assets (id, coin, balance, userid, datetime) VALUES " . implode(", ", $values);
    mysqli_query($conn, $sql);
}




$total_balance = $user_btc_bal + $user_eth_bal +   $user_sol_bal +
    $user_tron_bal +  $user_usdttrc_bal +
    $user_usdterc_bal;



$total_value = $user_btc_value + $user_eth_value + $user_sol_value + $user_tron_value + $user_usdttrc_value + $user_usdterc_value;

$total_income = 0;
$total_expenditure = 0;

$qqq = mysqli_query($conn, "SELECT sum(value) as 'sm' FROM transaction WHERE receiver_id = '$userid' and status = 'SUCCESS' and type = 'CREDIT' ");

if($rowq = mysqli_fetch_assoc($qqq)){
    $total_income = $rowq["sm"]??0;
}


$qqq = mysqli_query($conn, "SELECT sum(value) as 'sm' FROM transaction WHERE sender_id = '$userid' and (status = 'SUCCESS' or status = 'PENDING') and (type = 'SENT' OR type = 'FEE')");
if($rowq = mysqli_fetch_assoc($qqq)){
   $total_expenditure = $rowq["sm"]??0; 
}



$email_verified = 0;
$que = mysqli_query($conn, "select emailverified from users where email = '$email' and emailverified = 1");
if (mysqli_num_rows($que) > 0) {
    $email_verified = 1;
}

$btc_address = "";
$btc_qrcode = "";

$eth_address = "";
$eth_qrcode = "";

$tron_address = "";
$tron_qrcode = "";

$sol_address = "";
$sol_qrcode = "";

$usdtt_address = "";
$usdtt_qrcode = "";

$usdte_address = "";
$usdte_qrcode = "";


$qu = mysqli_query($conn, "select walletaddress,qrcode from wallet_address where asset = 'BITCOIN'");
if ($row = mysqli_fetch_assoc($qu)) {
    $btc_address = $row['walletaddress'];
    $btc_qrcode = $row['qrcode'];
}
$qu = mysqli_query($conn, "select walletaddress,qrcode from wallet_address where asset = 'ETHEREUM'");
if ($row = mysqli_fetch_assoc($qu)) {
    $eth_address = $row['walletaddress'];
    $eth_qrcode = $row['qrcode'];
}
$qu = mysqli_query($conn, "select walletaddress,qrcode from wallet_address where asset = 'SOLANA'");
if ($row = mysqli_fetch_assoc($qu)) {
    $sol_address = $row['walletaddress'];
    $sol_qrcode = $row['qrcode'];
}
$qu = mysqli_query($conn, "select walletaddress,qrcode from wallet_address where asset = 'TRON'");
if ($row = mysqli_fetch_assoc($qu)) {
    $tron_address = $row['walletaddress'];
    $tron_qrcode = $row['qrcode'];
}
$qu = mysqli_query($conn, "select walletaddress,qrcode from wallet_address where asset = 'USDT_TRC20'");
if ($row = mysqli_fetch_assoc($qu)) {
    $usdtt_address = $row['walletaddress'];
    $usdtt_qrcode = $row['qrcode'];
}
$qu = mysqli_query($conn, "select walletaddress,qrcode from wallet_address where asset = 'USDT_ERC20'");
if ($row = mysqli_fetch_assoc($qu)) {
    $usdte_address = $row['walletaddress'];
    $usdte_qrcode = $row['qrcode'];
}


// $eth_address = "0x1F3d361145Eb011a266c18Dcc88CBB56283d9d96";
// $tron_address = "TPaFUva6JSVysPUnVMuZCtqxAPraK9XrXB";
// $btc_address = "bc1qxsxlze2h4whv05kpuxv0wg2nmtlj0awl2p7faq";
// $_sol_address = "D92vdVPqkGWX1hM8zDpdV5B5XMUVbdQJ35";
// $usdtt_address = "TPaFUva6JSVysPUnVMuZCtqxAPraK9XrXB";
// $usdte_address = "0x1F3d361145Eb011a266c18Dcc88CBB56283d9d96";

// $eth_qrcode = "my_eth.jpg";
// $tron_qrcode = "my_tron.jpg";
// $_sol_qrcode = "my_sol.jpg";
// $usdtt_qrcode = "my_usdtt.jpg";
// $usdte_qrcode = "my_usdte.jpg";
// $btc_qrcode = "my_btc.jpg";


$data[] = [
    'email_verified' => $email_verified,
    'total_balance' => $total_balance,
    'total_value' => $total_value,
    'total_income' => $total_income,
    'total_expenditure'=> $total_expenditure,
    'user_btc_bal' => $user_btc_bal,
    'user_eth_bal' => $user_eth_bal,
    'user_sol_bal' => $user_sol_bal,
    'user_tron_bal' => $user_tron_bal,
    'user_usdttrc_bal' => $user_usdttrc_bal,
    'user_usdterc_bal' => $user_usdterc_bal,
    'btc' => $btc,
    'eth' => $eth,
    'sol' => $sol,
    'tron' => $tron,
    'usdttrc' => $usdtTrc,
    'usdterc' => $usdtErc,
    'btcChange' => $btcChange,
    'ethChange' => $ethChange,
    'solChange' => $solChange,
    'tronChange' => $tronChange,
    'usdttrcChange' => $usdttrcChange,
    'usdtercChange' => $usdtercChange,
    'btc_address' => $btc_address,
    'btc_qrcode' => $btc_qrcode,
    'eth_address' => $eth_address,
    'eth_qrcode' => $eth_qrcode,
    'tron_address' => $tron_address,
    'tron_qrcode' => $tron_qrcode,
    'sol_address' => $sol_address,
    'sol_qrcode' => $sol_qrcode,
    'usdtt_address' => $usdtt_address,
    'usdtt_qrcode' => $usdtt_qrcode,
    'usdte_address' => $usdte_address,
    'usdte_qrcode' => $usdte_qrcode,
    'user_btc_value' => $user_btc_value,
    'user_eth_value' => $user_eth_value,
    'user_sol_value' => $user_sol_value,
    'user_tron_value' => $user_tron_value,
    'user_usdttrc_value' => $user_usdttrc_value,
    'user_usdterc_value' => $user_usdterc_value
];
echo json_encode(['status' => 'success', 'data' => $data]);


