<?php
session_start();

$captcha_text = '';
$characters = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
for ($i = 0; $i < 6; $i++) {
    $captcha_text .= $characters[rand(0, strlen($characters) - 1)];
}

// Store in session
$_SESSION['captcha'] = $captcha_text;

// Create image
$width = 200;
$height = 60;
$image = imagecreatetruecolor($width, $height);

// Colors
$bg_color = imagecolorallocate($image, 255, 255, 255); // white
$text_color = imagecolorallocate($image, 0, 0, 0);     // black
$noise_color = imagecolorallocate($image, 100, 120, 180); // noise

// Fill background
imagefilledrectangle($image, 0, 0, $width, $height, $bg_color);

// Add background noise (dots)
for ($i = 0; $i < 1500; $i++) {
    imagesetpixel($image, rand(0, $width), rand(0, $height), $noise_color);
}

// Add obfuscating lines
for ($i = 0; $i < 5; $i++) {
    imageline($image, rand(0, $width), rand(0, $height), 
              rand(0, $width), rand(0, $height), $noise_color);
}

// Add text (rotated and spaced)
$font_size = 16;
$font_path = __DIR__ . '/font/ARIAL.TTF'; // Use a decorative/distorted font
$x = 15;

for ($i = 0; $i < strlen($captcha_text); $i++) {
    $angle = rand(-25, 25);
    $y = rand(35, 50);
    imagettftext($image, $font_size, $angle, $x, $y, $text_color, $font_path, $captcha_text[$i]);
    $x += 28; // space between characters
}

// Output image
header('Content-Type: image/png');
imagepng($image);
imagedestroy($image);
