<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');


require 'connect.php';
// Get DataTables parameters
$draw = isset($_POST['draw']) ? intval($_POST['draw']) : 1;
$start = isset($_POST['start']) ? intval($_POST['start']) : 0;
$length = isset($_POST['length']) ? intval($_POST['length']) : 10;
$searchValue = isset($_POST['search']['value']) ? $conn->real_escape_string($_POST['search']['value']) : '';
$orderColumn = isset($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
$orderDir = isset($_POST['order'][0]['dir']) ? $conn->real_escape_string($_POST['order'][0]['dir']) : 'desc';

// Column mapping for ordering
$columns = [
    0 => 't.asset',
    1 => 't.quantity',
    2 => 'sender.username',
    3 => 'receiver.username',
    4 => 't.status',
    5 => 't.datetime'
];

// Base query with JOINs to get usernames and emails
$query = "SELECT SQL_CALC_FOUND_ROWS 
            t.id, t.asset, t.quantity, t.value, 
            t.sender_id, t.receiver_id, 
            t.status, t.type, t.datetime, 
            t.receiver_walletaddress, t.transtype,
            sender.username as sender_username,
            sender.email as sender_email,
            receiver.username as receiver_username,
            receiver.email as receiver_email
          FROM transaction t
          LEFT JOIN users sender ON t.sender_id = sender.id
          LEFT JOIN users receiver ON t.receiver_id = receiver.id
          WHERE 1=1 AND type !='FEE'";

// Add search condition if search value exists
if (!empty($searchValue)) {
    $query .= " AND (
        t.asset LIKE '%$searchValue%' OR
        t.quantity LIKE '%$searchValue%' OR
        t.value LIKE '%$searchValue%' OR
        t.status LIKE '%$searchValue%' OR
        t.type LIKE '%$searchValue%' OR
        t.datetime LIKE '%$searchValue%' OR
        t.receiver_walletaddress LIKE '%$searchValue%' OR
        t.transtype LIKE '%$searchValue%' OR
        sender.username LIKE '%$searchValue%' OR
        sender.email LIKE '%$searchValue%' OR
        receiver.username LIKE '%$searchValue%' OR
        receiver.email LIKE '%$searchValue%'
    )";
}

// Validate order column
$orderColumn = isset($columns[$orderColumn]) ? $columns[$orderColumn] : 't.datetime';

// Add ordering
$query .= " ORDER BY datetime desc";

// Add pagination
$query .= " LIMIT $start, $length";

// Execute query
$result = mysqli_query($conn, $query);
if (!$result) {
    die(json_encode(['error' => 'Query failed: ' . mysqli_error($conn)]));
}

$transactions = [];
$total = 0;
function shortenString($str)
{
    if (strlen($str) > 15) {
        return substr($str, 0, 5) . '...' . substr($str, -5);
    }
    return $str;
}
// Process results
if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $assetAbbrv = "";
        switch ($row['asset']) {
            case 'Bitcoin':
                $assetAbbrv = "BTC";
                break;
            case 'Ethereum':
                $assetAbbrv = "ETH";
                break;
            case 'Solana':
                $assetAbbrv = "SOL";
                break;
            case 'Tron':
                $assetAbbrv = "TRON";
                break;
            case 'Usdt_trc20':
            case 'Usdt_erc20':
                $assetAbbrv = "USDT";
                break;
        }

        // Determine if sender/receiver is the system
        $sendername = ($row['sender_id'] == email_username) ? site_name : $row['sender_username'];
        $senderemail = ($row['sender_id'] == email_username) ? email_username : $row['sender_email'];
        $receivername = ($row['receiver_id'] == email_username) ? site_name : $row['receiver_username'];
        $receiveremail = ($row['receiver_id'] == email_username) ? email_username : $row['receiver_email'];

        

        $typ = "";
        if ($row['type'] == "CREDIT") {
            $typ = "Received";
        } else if ($row["type"] == "DEBIT") {
            $typ = "Debited";
        } elseif ($row["type"] == "SENT") {
            $typ = "Sent";
            $receivername = "";
            $receiveremail = shortenString($row["receiver_walletaddress"]);
        } elseif ($row["type"] == "FEE") {
            $typ = "Fee";
        }
        $transactions[] = [
            'coin' => $row['asset'],
            'abbrv' => $assetAbbrv,
            'amount_usdt' => $row['quantity'],
            'amount_usd' => $row['value'],
            'sender_name' => $sendername,
            'sender_email' => $senderemail,
            'receiver_name' => $receivername,
            'receiver_email' => $receiveremail,
            'status' => $row['status'],
            'transtype' => $row['transtype'],
            'type' => $row['type'],
            'datetime' => date("d M, Y h:i a", strtotime($row['datetime'])),
        ];

        $total += floatval($row['value']);
    }
}

// Get total records count
$totalRecordsResult = mysqli_query($conn, "SELECT FOUND_ROWS()");
$totalRecords = mysqli_fetch_row($totalRecordsResult)[0];

// Get filtered records count
if (!empty($searchValue)) {
    $filteredRecords = count($transactions);
} else {
    $filteredRecords = $totalRecords;
}

// Close connection
mysqli_close($conn);

// Prepare response
$response = [
    "draw" => $draw,
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => $filteredRecords,
    "data" => $transactions,
    "total" => $total
];

echo json_encode($response);
?>